/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.rolfmao.upgradednetherite.config.UpgradedNetheriteConfig;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;

public class ArmorBlazeriteModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> BLAZERITE = TConstruct.createKey((String)"blazerite_armor");

    public ArmorBlazeriteModifier() {
        MinecraftForge.EVENT_BUS.addListener(ArmorBlazeriteModifier::onUpdateApply);
        MinecraftForge.EVENT_BUS.addListener(ArmorBlazeriteModifier::onLivingAttackEvent);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(BLAZERITE, false, null));
    }

    private static void onUpdateApply(LivingEvent.LivingTickEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && living.m_6084_()) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                int level = (Integer)holder.get(BLAZERITE, (Object)0);
                if (level > 0 && living instanceof Player) {
                    Player player = (Player)living;
                    player.m_20095_();
                    if (UpgradedNetheriteConfig.EnableLavaSpeed && player.m_20077_() && !player.m_150110_().f_35935_) {
                        player.m_20256_(player.m_20184_().m_82542_((double)1.66f, 1.0, (double)1.66f));
                    }
                }
            });
        }
    }

    public static void onLivingAttackEvent(LivingAttackEvent event) {
        EquipmentContext context;
        LivingEntity living = event.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && living.m_6084_()) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                int level = (Integer)holder.get(BLAZERITE, (Object)0);
                if (level > 0 && living instanceof Player) {
                    Player player = (Player)living;
                    if (event.getSource().m_19384_() && UpgradedNetheriteConfig.EnableFireImmune) {
                        if (event.isCancelable()) {
                            event.setCanceled(true);
                        }
                        player.m_20095_();
                    }
                }
            });
        }
    }
}

